<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TypeRequirement extends Model 
{

    protected $table = 'type_requirements';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('type_id', 'requirement_id');

    public function type()
    {
        return $this->belongsTo('App\Models\Type');
    }

    public function requirement()
    {
        return $this->belongsTo('App\Models\Requirement');
    }

}